// Documentation for Mermaid: https://github.com/mermaid-js/mermaid/blob/develop/docs/usage.md

// This imitates having a <script>-element with an external resource in the <head> segment. 
const script = document.createElement('script');
script.setAttribute('src', 'https://cdn.jsdelivr.net/npm/mermaid/dist/mermaid.min.js');
script.onload = function() {
	// Default font is: "trebuchet ms",verdana,arial,sans-serif
	//  It seems to be tricky to change in a reliable way
	// FIXME: Look into using pre.mermaid described here: https://mermaid.js.org/config/usage.html

	mermaid.initialize({ startOnLoad: false/*, themeVariables: { "fontFamily": "sans-serif", "fontSize": 11 }*/ });

	var global_err = "";
	mermaid.parseError = function(err, hash) {
		global_err = err;
	};

	window.webkit.messageHandlers.stateHandler.postMessage({ type: 'initialized' });
};
script.onerror = function() { window.webkit.messageHandlers.stateHandler.postMessage({ type: 'error', message: 'Failed fetching mermaid files' }); };

document.head.appendChild(script);

window.mm_perform_action = function(input) {
	// The svg_id random value isn't strictly necessary since MailMate will also inline the stylesheet.
	const promise = mermaid.render(`svg_id_${Math.floor(Math.random() * 1000000)}`,input);
	promise.then((res) => {
		window.webkit.messageHandlers.stateHandler.postMessage({ result: res.svg });
	}).catch((error) => {
		// The error.message value is often pretty useless here. We try to get something better.
		// Note: The use of a global error value only works because JavaScript is single-threaded.
		global_err = null;
		mermaid.parse(input); // Needed globalThis on pre-macOS 11.0.
		window.webkit.messageHandlers.stateHandler.postMessage({ type: 'error', message: global_err ? global_err : error.message });
	});

	return null;
}

true; // Needed on pre-macOS 11.0.
