function getHeight() {

  // This is a quick check when there is no caret_uuid.
  let caretHeight = -1.0;
  if(document.body.hasAttribute("caret_uuid")) {
	  let uuid = document.body.getAttribute("caret_uuid");
	  if(uuid) {
		  let attributeQuery = "[" + CSS.escape(uuid) + "]";
		  let element = document.querySelector(attributeQuery);
		  if(element) {
			  let fraction = parseFloat(element.getAttribute(uuid));
			  if(fraction >= 0 && fraction <= 1.0) { // Safety catch
		        caretHeight = element.getBoundingClientRect().top + fraction*(element.getBoundingClientRect().bottom - element.getBoundingClientRect().top);
			  }
		  }
	  }
  }

  let height = document.documentElement.getBoundingClientRect().height;

  if(height < 100) {
	  // Attempt to work around issue reported by email May 13, 19:54
	  //  This is very tricky to get right. Maybe there's a better way, but it requires test-data.
	  let element = document.querySelector("div[style*=absolute]");
	  if(element) {
		  let absoluteHeight = element.clientHeight;
		  if(absoluteHeight > height) {
			  height = absoluteHeight;
		  }
	 }
  }

  return [height, caretHeight];
}

// This is only needed once per document
document.documentElement.style.setProperty('height', 'auto', 'important');
document.documentElement.style.setProperty('minHeight', 'auto', 'important');
document.body.style.overflowY = 'hidden'; // Hides vertical scroller

// FIXME: This should be reported to MailMate and put into a warning -- including the original iframe code.
document.querySelectorAll('iframe').forEach(iframe => {
	const div = document.createElement("div");
	div.textContent = "[Removed <iframe>]";
	iframe.replaceWith(div);
});

// Setup observer
const resizeObserver = new ResizeObserver(entries => { window.webkit.messageHandlers.heightMessageHandler.postMessage(getHeight()); }); // entries[0].target.clientHeight
resizeObserver.observe(document.body);
