// var res = ""; // Only used when debugging

function findNumbers(str, scheme) {
	let numbers = [];
	let location = str.indexOf(scheme);
	while(location != -1) {
		location = location + scheme.length;
		let noscheme = str.substr(location+1);
		let numberLength = noscheme.indexOf('/');
		numbers.push(parseInt(noscheme.substr(0, numberLength)));
		location = str.indexOf(scheme, location+numberLength);
	}
	return numbers;
}

// Given a string and some ids, create an unblocked string
function unblockResources(str, scheme, idSet) {
	if(str) {
		let blockScheme = "block-" + scheme;
		let numbers = findNumbers(str, blockScheme);

		if(numbers.length > 0) {
			for(let i=0; i<numbers.length; i++) {
				if(idSet.has(numbers[i])) {
					str = str.replace(blockScheme+":"+numbers[i]+"/", scheme+":"+numbers[i]+"/");
				}
			}
			return str;
		}
	}
	return null;
}

// Note: It's important to set srcset before src. If they contain the same URL the non-blocking of src can trigger a still blocked srcset URL to be loaded before it's non-blocked (triggering a detail to be added). This triggers an incorrect detail to be generated (there are other and probably more robust ways to solve this though).
function loadImgResources(scheme, idSet) {
	// img
	let imgElements = document.getElementsByTagName('img');
	for(let i=0; i<imgElements.length; i++) {
		// srcset
		let str = imgElements[i].srcset;
		if(str = unblockResources(str, scheme, idSet)) {
			imgElements[i].srcset = str;
		}

		// src
		str = imgElements[i].src;
		if(str = unblockResources(str, scheme, idSet)) {
			imgElements[i].src = str;
		}
	}
}

function loadObjectResources(scheme, idSet) {
	// object
	let elements = document.getElementsByTagName('object');
	for(let i=0; i<elements.length; i++) {
		let str = elements[i].data;
		if(str = unblockResources(str, scheme, idSet)) {
			elements[i].data = str;
		}
	}
}

function loadLinkResources(scheme, idSet) {
	// link
	let elements = document.getElementsByTagName('link');
	for(let i=0; i<elements.length; i++) {
		let str = elements[i].href;
		if(str = unblockResources(str, scheme, idSet)) {
			elements[i].href = str;
		}
	}
}

// Documentation: "While this property is considered read-only, it is possible to set an inline style by assigning a string directly to the style property."
function loadInlineStylesheetResources(scheme, idSet) {
	let styledElements = document.querySelectorAll("*[style]");
	for(let i=0;i<styledElements.length;i++) {
		let style = styledElements[i].style;
		if(style) {
			let str = style.cssText;
			if(str = unblockResources(str, scheme, idSet)) {
				styledElements[i].style = str;
			}
		}
	}
}

function loadStylesheetResources(scheme, idSet) {
	for(let sheet of document.styleSheets) {
		// res = res + "sheet: " + sheet + "\n";
		let ruleList = sheet.cssRules;
		if(ruleList)
		{
			for (let i=0;i<ruleList.length;i++) {
				let str = ruleList[i].cssText;
				if(str = unblockResources(str, scheme, idSet)) {
					sheet.deleteRule(i);
					sheet.insertRule(str, i);
				}
			}
		}
	}

	// return res;
}

function loadDeprecatedBackgroundResources(scheme, idSet) {
	let backgroundElements = document.querySelectorAll("*[background]");
	for(let i=0;i<backgroundElements.length;i++) {
		let str = backgroundElements[i].getAttribute("background");
		if(str = unblockResources(str, scheme, idSet)) {
			backgroundElements[i].setAttribute("background", str);
		}
	}
}
