// Based on: http://www.icab.de/blog/2010/01/12/search-and-highlight-text-in-uiwebview/
//  Extended to be able to highlight a current item (for previous/next functionality)
//  Changed to get a sensible order of search results
//  Highlighting functions moved to separate file

// We're using a global variable to store the number of occurrences
var UUID_ActiveIndex = -1;
var UUID_SearchElements = [];

// helper function, recursively searches in elements and their child nodes
function UUID_HighlightAllOccurencesOfStringForElement(element,keyword) {
  var index = 0;
  if (element) {
    if (element.nodeType == 1) { // Element node
      if (element.style.display != "none" && element.nodeName.toLowerCase() != 'select') {
        for (var i=element.childNodes.length-1; i>=0; i--) {
          UUID_HighlightAllOccurencesOfStringForElement(element.childNodes[i],keyword);
        }
      }
    }
    else if (element.nodeType == 3) {        // Text node
      while (true) {
        var value = element.nodeValue;  // Search for keyword in text node
        var idx = value.toLowerCase().lastIndexOf(keyword);

        if (idx < 0) break;             // not found, abort

        var span = document.createElement("span");
        UUID_SearchElements.push(span);
        var text = document.createTextNode(value.substr(idx,keyword.length));
        span.appendChild(text);
        span.setAttribute("class","UUIDHighlight");
        UUID_HighlightElement(span);
        text = document.createTextNode(value.substr(idx+keyword.length));
        element.deleteData(idx, value.length - idx);
        var next = element.nextSibling;
        element.parentNode.insertBefore(span, next);
        element.parentNode.insertBefore(text, next);
      }
    }
  }
}

// the main entry point to start the search
function UUID_HighlightAllOccurencesOfString(keyword) {
  UUID_RemoveAllHighlights();
  UUID_HighlightAllOccurencesOfStringForElement(document.body, keyword.toLowerCase());
  UUID_SearchElements.reverse(); // The search above actually happens in reverse.
  return UUID_SearchElements.length;
}

// the main entry point to highlight a current item (find next/previous)
function UUID_HighlightIndex(newActiveIndex) {
  if (UUID_ActiveIndex != -1) {
    UUID_HighlightElement(UUID_SearchElements[UUID_ActiveIndex]);
  }
  UUID_ActiveIndex = newActiveIndex;
  if (UUID_ActiveIndex != -1) {
    var elem = UUID_SearchElements[UUID_ActiveIndex];
    UUID_HighlightActiveElement(elem);
    return [ elem.getBoundingClientRect().top, elem.offsetHeight ];
  }
  return [ -1.0, -1.0 ];
}

// helper function, recursively removes the highlights in elements and their children
function UUID_RemoveAllHighlightsForElement(element) {
  if (element) {
    if (element.nodeType == 1) {
      if (element.getAttribute("class") == "UUIDHighlight") {
        var text = element.removeChild(element.firstChild);
        element.parentNode.insertBefore(text,element);
        element.parentNode.removeChild(element);
        return true;
      } else {
        var normalize = false;
        for (var i=element.childNodes.length-1; i>=0; i--) {
          if (UUID_RemoveAllHighlightsForElement(element.childNodes[i])) {
            normalize = true;
          }
        }
        if (normalize) {
          element.normalize();
        }
      }
    }
  }
  return false;
}

// the main entry point to remove the highlights
function UUID_RemoveAllHighlights() {
  UUID_ActiveIndex = -1;
  UUID_SearchElements = []; // FIXME: Maybe use this to optimize UUID_RemoveAllHighlightsForElement()?
  UUID_RemoveAllHighlightsForElement(document.body);
}
