function updateHeight() {
	// Optimize: This is only needed the first time updateHeight() is called 
  document.documentElement.style.setProperty('height', 'auto', 'important');
  document.documentElement.style.setProperty('minHeight', 'auto', 'important');
  document.documentElement.style.setProperty('minHeight', 'auto', 'important');
  document.body.style.overflowY = 'hidden';

	// Optimize: The caller knows if this is needed (only for the composer)
  let caretHeight = -1.0;
  if(document.body.hasAttribute("caret_uuid")) {
	  let uuid = document.body.getAttribute("caret_uuid");
	  if(uuid) {
		  let attributeQuery = "[" + CSS.escape(uuid) + "]";
		  let element = document.querySelector(attributeQuery);
		  if(element) {
			  let fraction = parseFloat(element.getAttribute(uuid));
			  if(fraction >= 0 && fraction <= 1.0) { // Safety catch
		        caretHeight = element.getBoundingClientRect().top + fraction*(element.getBoundingClientRect().bottom - element.getBoundingClientRect().top);
			  }
		  }
	  }
  }

  let height = document.documentElement.getBoundingClientRect().height;
  return [height, caretHeight];
}
