// Documentation for Prism: https://prismjs.com/docs/Prism.html

// Disable automatic highlighting
window.Prism = window.Prism || {};
window.Prism.manual = true;

// This imitates having a <script>-element with an external resource in the <head> segment. 
const script = document.createElement('script');
script.onload = function() {
	const script2 = document.createElement('script');
	script2.onload = function() { window.webkit.messageHandlers.stateHandler.postMessage({ type: 'initialized' }); };
	script2.onerror = function() { window.webkit.messageHandlers.stateHandler.postMessage({ type: 'error', message: 'Failed fetching prism files' }); };
	document.head.appendChild(script2);
	script2.setAttribute('src', 'https://cdn.jsdelivr.net/npm/prismjs@1.x/plugins/autoloader/prism-autoloader.js');
};
script.onerror = function() { window.webkit.messageHandlers.stateHandler.postMessage({ type: 'error', message: 'Failed fetching prism files' }); };
script.setAttribute('src', 'https://cdn.jsdelivr.net/npm/prismjs@1.x/components/prism-core.min.js'); // prism.min.js

// Let's fetch a theme to be used. We only do this once. In principle, we could fetch all of them or fetch them on demand instead (within mm_perform_action). That way, an argument to mm_perform_action could tell us which style to use.
// FIXME: Make it like the autoloader for languages caching all themes.
var theme;
fetch('https://cdn.jsdelivr.net/npm/prismjs@1.x/themes/prism.css')
	.then((response) => {
		if (!response.ok) {
			throw new Error('network error');
		}
		return response.text();
	})
	.then((str) => {
		theme = str;
		document.head.appendChild(script); // For now, triggers loading the scripts further above.
	})
	.catch((error) => {
		window.webkit.messageHandlers.stateHandler.postMessage({ type: 'error', message: 'Failed fetching theme' });
	});

// Function called by MailMate
window.mm_perform_action = function(obj) {

	// TODO: Maybe a diagram-inspired way to get per-section settings like explicit themes or the use of the linenumber plugin?
	//  %%{init: {'theme': 'base', 'themeVariables': { 'primaryColor': '#ff0000'}}}%%

	let str = obj['input'];
	let language = obj['env']['CODE_LANGUAGE'];

	if(language == "email") {
		// Note: We have the same code in highlight.js
		Prism.languages.email = {
		  header: {
		    pattern: /^[A-Z][a-zA-Z0-9-_]{2,}(?=:)/gm,
		    alias: "function",
		  },
		  // domain: { // Maybe change to full URLs -- or use the autolink plugin instead?
		  //   pattern: /(?!:\/\/)([a-zA-Z0-9-_]+\.)*[a-zA-Z0-9][a-zA-Z0-9-_]+\.[a-zA-Z]{2,11}?\b/gm,
		  //   alias: "tag",
		  // },
		  boundary: {
		    pattern: /^\-{2}.*(\b|\B)/gm,
		    alias: "operator"
		  },
		  email: {
		    pattern: /(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))/,
		    alias: "keyword",
		    greedy: true
		  },
		  ipv4: {
		    pattern: /(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\b/gm,
		    alias: "string",
		  },
		  ipv6: {
			pattern: /((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))/g,
			alias: "string",
		  }
		};

		var res = "<style>" + theme + "</style>" + window.Prism.highlight(str, window.Prism.languages[language], language);
		window.webkit.messageHandlers.stateHandler.postMessage({ result: res });
	} else {
		// Return result after loading language
		Prism.plugins.autoloader.loadLanguages(language, (loaded_languages) => {
			var res = "<style>" + theme + "</style>" + window.Prism.highlight(str, window.Prism.languages[language], language);
			window.webkit.messageHandlers.stateHandler.postMessage({ result: res });
		}, (failed_language) => {
			window.webkit.messageHandlers.stateHandler.postMessage({ type: 'error', message: "failed to load language: " + language });
		});
	}

	return null;
}

true; // Needed on pre-macOS 11.0.
