function selectedHTML() {
	let html = "";
	let sel = window.getSelection();
	if(sel.rangeCount) {
		let container = document.createElement("div");
		for(let i = 0, len = sel.rangeCount; i < len; ++i) {
			container.appendChild(sel.getRangeAt(i).cloneContents());
		}
		html = container.innerHTML;
	}
	return html;
}

function selectionData () {
	let ws = "normal";
	const selection = window.getSelection();
	if(selection) {
		let anchorNode = selection.anchorNode;
		if(anchorNode) {
			let parentElement = anchorNode.parentElement;
			if(parentElement) {
				let style = window.getComputedStyle(parentElement);
				if(style) {
					ws = style.getPropertyValue('white-space');
				}
			}
		}
	}
	return { "html": selectedHTML(), "text": window.getSelection().toString(), "white-space": ws };
}

function getSelectionAndSendMessage() {
	window.webkit.messageHandlers.selectionMessageHandler.postMessage(selectionData());
}

document.onselectionchange = getSelectionAndSendMessage;

// Drop these if the above works (which it appears to do on at least 10.15+)
// document.onmouseup      = getSelectionAndSendMessage;
// document.onkeyup        = getSelectionAndSendMessage;
// document.oncontextmenu  = getSelectionAndSendMessage;
